package com.ejie.aa17a.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aRegistroMaestroDao;
import com.ejie.aa17a.model.Aa17aRegistroMaestro;
import com.ejie.x38.dto.Pagination;

/**
 * Aa17aRegistroMaestroDaoImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

@Transactional
public class Aa17aRegistroMaestroDaoImpl implements Aa17aRegistroMaestroDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Aa17aRegistroMaestro> rwMap = new RowMapper<Aa17aRegistroMaestro>() {
		public Aa17aRegistroMaestro mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Aa17aRegistroMaestro(
					resultSet.getLong("IDREGISTRO"), resultSet.getString("DESCRIPCIONCASTELLANO"), resultSet.getString("DESCRIPCIONEUSKERA"), resultSet.getDate("FECHABAJA"), resultSet.getLong("IDPADRE"), resultSet.getLong("IDABUELO")
			);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aregistromaestro
	 *            Pagination
	 * @return Aa17aRegistroMaestro
	 */
	public Aa17aRegistroMaestro add(Aa17aRegistroMaestro aa17aregistromaestro) {
		String query = "INSERT INTO AA17A_REGISTRO_MAESTRO (ID_REGISTRO, DESCRIPCION_CASTELLANO, DESCRIPCION_EUSKERA, FECHA_BAJA, ID_PADRE, ID_ABUELO) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, aa17aregistromaestro.getIdRegistro(), aa17aregistromaestro.getDescripcionCastellano(), aa17aregistromaestro.getDescripcionEuskera(), aa17aregistromaestro.getFechaBaja(), aa17aregistromaestro.getIdPadre(), aa17aregistromaestro.getIdAbuelo());
		return aa17aregistromaestro;
	}

	/**
	 * Updates a single row in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aregistromaestro
	 *            Pagination
	 * @return Aa17aRegistroMaestro
	 */
	public Aa17aRegistroMaestro update(Aa17aRegistroMaestro aa17aregistromaestro) {
		String query = "UPDATE AA17A_REGISTRO_MAESTRO SET  WHERE ID_REGISTRO=? AND DESCRIPCION_CASTELLANO=? AND DESCRIPCION_EUSKERA=? AND FECHA_BAJA=? AND ID_PADRE=? AND ID_ABUELO=?";
		this.jdbcTemplate.update(query, aa17aregistromaestro.getIdRegistro(), aa17aregistromaestro.getDescripcionCastellano(), aa17aregistromaestro.getDescripcionEuskera(), aa17aregistromaestro.getFechaBaja(), aa17aregistromaestro.getIdPadre(), aa17aregistromaestro.getIdAbuelo());
		return aa17aregistromaestro;
	}

	/**
	 * Finds a single row in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aregistromaestro
	 *            Pagination
	 * @return Aa17aRegistroMaestro
	 */
	@Transactional(readOnly = true)
	public Aa17aRegistroMaestro find(Aa17aRegistroMaestro aa17aregistromaestro) {
		String query = "SELECT t1.ID_REGISTRO IDREGISTRO, t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO, t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA, t1.FECHA_BAJA FECHABAJA, t1.ID_PADRE IDPADRE, t1.ID_ABUELO IDABUELO FROM AA17A_REGISTRO_MAESTRO t1  WHERE t1.ID_REGISTRO = ?   AND t1.DESCRIPCION_CASTELLANO = ?   AND t1.DESCRIPCION_EUSKERA = ?   AND t1.FECHA_BAJA = ?   AND t1.ID_PADRE = ?   AND t1.ID_ABUELO = ?  ";

		List<Aa17aRegistroMaestro> aa17aregistromaestroList = this.jdbcTemplate.query(query, this.rwMap, aa17aregistromaestro.getIdRegistro(), aa17aregistromaestro.getDescripcionCastellano(), aa17aregistromaestro.getDescripcionEuskera(), aa17aregistromaestro.getFechaBaja(), aa17aregistromaestro.getIdPadre(), aa17aregistromaestro.getIdAbuelo());
		return (Aa17aRegistroMaestro) DataAccessUtils.uniqueResult(aa17aregistromaestroList);
	}

	/**
	 * Removes a single row in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aregistromaestro
	 *            Pagination
	 * @return
	 */
	public void remove(Aa17aRegistroMaestro aa17aregistromaestro) {
		String query = "DELETE FROM AA17A_REGISTRO_MAESTRO WHERE ID_REGISTRO=? AND DESCRIPCION_CASTELLANO=? AND DESCRIPCION_EUSKERA=? AND FECHA_BAJA=? AND ID_PADRE=? AND ID_ABUELO=?";
		this.jdbcTemplate.update(query, aa17aregistromaestro.getIdRegistro(), aa17aregistromaestro.getDescripcionCastellano(), aa17aregistromaestro.getDescripcionEuskera(), aa17aregistromaestro.getFechaBaja(), aa17aregistromaestro.getIdPadre(), aa17aregistromaestro.getIdAbuelo());
	}

	/**
	 * Finds a List of rows in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aregistromaestro
	 *            Aa17aRegistroMaestro
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aa17aRegistroMaestro> findAll(Aa17aRegistroMaestro aa17aregistromaestro, Pagination pagination) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_REGISTRO IDREGISTRO,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_BAJA FECHABAJA,t1.ID_PADRE IDPADRE,t1.ID_ABUELO IDABUELO ");
		query.append("FROM AA17A_REGISTRO_MAESTRO t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17aregistromaestro);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Aa17aRegistroMaestro>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Aa17aRegistroMaestro table.
	 * 
	 * @param aa17aregistromaestro
	 *            Aa17aRegistroMaestro
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa17aRegistroMaestro aa17aregistromaestro) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA17A_REGISTRO_MAESTRO t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa17aregistromaestro);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Finds rows in the Aa17aRegistroMaestro table using like.
	 * 
	 * @param aa17aregistromaestro
	 *            Aa17aRegistroMaestro
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aa17aRegistroMaestro> findAllLike(Aa17aRegistroMaestro aa17aregistromaestro, Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.ID_REGISTRO IDREGISTRO,t1.DESCRIPCION_CASTELLANO DESCRIPCIONCASTELLANO,t1.DESCRIPCION_EUSKERA DESCRIPCIONEUSKERA,t1.FECHA_BAJA FECHABAJA,t1.ID_PADRE IDPADRE,t1.ID_ABUELO IDABUELO ");
		query.append("FROM AA17A_REGISTRO_MAESTRO t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa17aregistromaestro, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}

		return (List<Aa17aRegistroMaestro>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Aa17aRegistroMaestro table using like.
	 * 
	 * @param aa17aregistromaestro
	 *            Aa17aRegistroMaestro
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa17aRegistroMaestro aa17aregistromaestro, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AA17A_REGISTRO_MAESTRO t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa17aregistromaestro, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa17aRegistroMaestro entity
	 * 
	 * @param aa17aregistromaestro
	 *            Aa17aRegistroMaestro Bean with the criteria values to filter
	 *            by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa17aRegistroMaestro aa17aregistromaestro) {

		StringBuffer where = new StringBuffer(Aa17aRegistroMaestroDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa17aregistromaestro != null && aa17aregistromaestro.getIdRegistro() != null) {
			where.append(" AND t1.ID_REGISTRO = ?");
			params.add(aa17aregistromaestro.getIdRegistro());
		}
		if (aa17aregistromaestro != null && aa17aregistromaestro.getDescripcionCastellano() != null) {
			where.append(" AND t1.DESCRIPCION_CASTELLANO = ?");
			params.add(aa17aregistromaestro.getDescripcionCastellano());
		}
		if (aa17aregistromaestro != null && aa17aregistromaestro.getDescripcionEuskera() != null) {
			where.append(" AND t1.DESCRIPCION_EUSKERA = ?");
			params.add(aa17aregistromaestro.getDescripcionEuskera());
		}
		if (aa17aregistromaestro != null && aa17aregistromaestro.getFechaBaja() != null) {
			where.append(" AND t1.FECHA_BAJA = ?");
			params.add(aa17aregistromaestro.getFechaBaja());
		}
		if (aa17aregistromaestro != null && aa17aregistromaestro.getIdPadre() != null) {
			where.append(" AND t1.ID_PADRE = ?");
			params.add(aa17aregistromaestro.getIdPadre());
		}
		if (aa17aregistromaestro != null && aa17aregistromaestro.getIdAbuelo() != null) {
			where.append(" AND t1.ID_ABUELO = ?");
			params.add(aa17aregistromaestro.getIdAbuelo());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa17aRegistroMaestro entity
	 * 
	 * @param aa17aregistromaestro
	 *            Aa17aRegistroMaestro Bean with the criteria values to filter
	 *            by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Aa17aRegistroMaestro aa17aregistromaestro, Boolean startsWith) {

		StringBuffer where = new StringBuffer(Aa17aRegistroMaestroDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa17aregistromaestro != null && aa17aregistromaestro.getIdRegistro() != null) {
			where.append(" AND t1.ID_REGISTRO = ?");
		}
		if (aa17aregistromaestro != null && aa17aregistromaestro.getDescripcionCastellano() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_CASTELLANO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa17aregistromaestro.getDescripcionCastellano().toUpperCase() + "%");
			}
			else {
				params.add("%" + aa17aregistromaestro.getDescripcionCastellano().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_CASTELLANO IS NOT NULL");
		}
		if (aa17aregistromaestro != null && aa17aregistromaestro.getDescripcionEuskera() != null) {
			where.append(" AND UPPER(t1.DESCRIPCION_EUSKERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa17aregistromaestro.getDescripcionEuskera().toUpperCase() + "%");
			}
			else {
				params.add("%" + aa17aregistromaestro.getDescripcionEuskera().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCRIPCION_EUSKERA IS NOT NULL");
		}
		if (aa17aregistromaestro != null && aa17aregistromaestro.getFechaBaja() != null) {
			where.append(" AND t1.FECHA_BAJA = ?");
		}
		if (aa17aregistromaestro != null && aa17aregistromaestro.getIdPadre() != null) {
			where.append(" AND t1.ID_PADRE = ?");
		}
		if (aa17aregistromaestro != null && aa17aregistromaestro.getIdAbuelo() != null) {
			where.append(" AND t1.ID_ABUELO = ?");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
